<?php $__env->startSection('content'); ?>
<div class="login-container">
    <h3>Silahkan masuk</h3>
    <form name="login-form" id="LoginForm">
        <div class="textfield-wrap" id="UsernameCheck">
            <div class="input-field">
                <input class="login-form" name="username" id="Username" type="text" minlength="5" maxlength="16"
                    required="required" autocomplete="off" autofocus="autofocus" placeholder='Nama Pengguna'>
                <i class="icon-user-wrap"></i>
            </div>
            <span class="tooltip" data-area="message"></span>
        </div>
        <div class="textfield-wrap" id="PasswordCheck">
            <div class="input-field">
                <input class="login-form" name="password" id="Password" type="password" minlength="6" maxlength="16"
                    required="required" placeholder='Kata Sandi'>
                <a href="#" class="toggle">
                    <i class="icon-visibility" id="pwd_visibility"></i>
                </a>
            </div>
            <span class="tooltip" data-area="message"></span>
        </div>
        <div class="textfield-wrap captcha-field" id="CaptchaCheck">
            <div class="input-field">
                <input type="text" name="captcha" id="Captcha" maxlength="4" autocomplete="off" required="required"
                    placeholder='Captcha'>
            </div>
            <img src="<?php echo e(captcha_src()); ?>" id="imgCaptcha" class="img-captcha img-thumbnail" width="100"
                style="height:40px !important;margin-left:10px;">
            <i class="fas fa-redo-alt" id="reloadCaptcha"></i>
            <span class="tooltip" data-area="message"></span>
        </div>
        <button name="buttonLogin" class="btn-primary" name="login" type="submit" value="true"
            id="LoginButton">Masuk</button>
    </form>


</div>

<div class="btn-default-container">
    <hr>
    <h3>Klik disini untuk menjadi anggota</h3>
    <a href="<?php echo e(route('login.register')); ?>" class="btn-default">Gabung sekarang</a>
</div>

<script>
    document.addEventListener('DOMContentLoaded', function () {
        const toggleBtn = document.querySelector('.toggle');
        const passwordInput = document.querySelector('#Password');

        if (toggleBtn && passwordInput) {
            toggleBtn.addEventListener('click', function (e) {
                e.preventDefault();
                passwordInput.type = (passwordInput.type === 'password') ? 'text' : 'password';
            });
        }
    });
</script>
<script>
    $("form[name=login-form]").on('submit', function(e) {
        e.preventDefault();
        let formData = {};
        $.each($(this).serializeArray(), function (i, val) {
             formData[val.name] = val.value
        });
        formData.username = formData.username.replace(/\s/g, '');
        let btnTxt = $("button[name=buttonLogin]").html()
        $.ajax({
            url: "<?php echo e(route('login')); ?>",
            type: 'POST',
            data: {
                _token: "<?php echo e(csrf_token()); ?>",
                username: formData.username,
                password: formData.password
            },
            beforeSend: function() {
                setLoading(true);
                $("input[name='username']").attr('readonly', true)
                $("input[name='password']").attr('readonly', true)
                $("button[name=buttonLogin]").attr('disabled', true)
            },
            success: function (data) {
                if (data.code == 200) {
	                let msg = '';
                    alert(data.message);
                    setLoading(false);
                    if (msg == '') {
                        setTimeout(function(){
                            location.reload();
                        }, 300);
                    }
                } else if (data.code == 250) {
	                let msg = '';
                    alert(data.message);
                    setLoading(false);
                    $("input[name='username']").removeAttr('readonly')
                $("input[name='password']").removeAttr('readonly')
                $("input[name='username']").val('')
                $("input[name='password']").val('')
                $("input[id='imgCaptcha']").val('')
                $("button[name=buttonLogin]").removeAttr('disabled')
                $("button[name=buttonLogin]").html(btnTxt)
                } else {
                    let msg = '';
                    alert(data.message);
                    setLoading(false);
                $("input[name='username']").removeAttr('readonly')
                $("input[name='password']").removeAttr('readonly')
                $("input[name='username']").val('')
                $("input[name='password']").val('')
                $("input[name='captcha']").val('')
                $("button[name=buttonLogin]").removeAttr('disabled')
                $("button[name=buttonLogin]").html(btnTxt)
                }
            },
            error: function (data) {
                let msg = '';
                $.each(data.responseJSON.errors, function (index, valueOfElement) {
                        msg += valueOfElement + '<br />'
                });
                alert(data.message);
                if (msg == '') {
                    location.reload();
                }
                $("input[name='username']").removeAttr('readonly')
                $("input[name='password']").removeAttr('readonly')
                $("input[name='username']").val('')
                $("input[name='password']").val('')
                $("input[name='captcha']").val('')
                $("button[name=buttonLogin]").removeAttr('disabled')
                $("button[name=buttonLogin]").html(btnTxt)
            }
        });
    });

    function setLoading(isSet) {
		var loader = $(".page-loader");
		isSet == true ? loader.show() : loader.hide();
	}
</script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend.layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /www/wwwroot/infiny-lara.demo-api.xyz/core/resources/views/frontend/auth/login.blade.php ENDPATH**/ ?>