<?php if (app('mobile-detect')->isMobile() && !app('mobile-detect')->isTablet()) : ?>

    <!DOCTYPE html>
    <html id="feProdAWS01" lang="id">
    <meta http-equiv="content-type" content="text/html;charset=UTF-8" />

    <head>
        <meta charset="utf-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
        <meta name="viewport" content="width=device-width,user-scalable=no,initial-scale=1, minimum-scale=1,maximum-scale=1">
        <meta name="apple-mobile-web-app-capable" content="yes">
        <meta name="mobile-web-app-capable" content="yes">
        <meta name="description" content="<?php echo e(general()->deskripsi); ?>">
        <meta name="keywords" content="<?php echo e(general()->keyword); ?>">

        <meta name="robots" content="index, follow" />
        <link rel="icon" type="image/x-icon" href="<?php echo e(env('AWS_URL')); ?><?php echo e(general()->icon_web); ?>">
        <title><?php echo e(general()->title); ?></title>

        <style>
            .user-view::AFTER {
                content: "💎🥇💎PLATINUM";
                /* background: gold; */
                /* padding-top: 10px; */
                color: gold;
                font-weight: bold;
                /* margin-top: 20px; */
            }
        </style>

        <link href="https://cdn.robotaset.com/assets/css/fonts.google.ubuntu.css" rel="stylesheet">
        <link href="https://cdn.robotaset.com/assets/thirdparty/font-awesome/css/brands.css" rel="stylesheet">
        <link href="https://cdn.robotaset.com/assets/thirdparty/font-awesome/css/regular.css" rel="stylesheet">
        <link href="https://cdn.robotaset.com/assets/thirdparty/font-awesome/css/solid.css" rel="stylesheet">
        <link href="https://cdn.robotaset.com/assets/thirdparty/font-awesome/css/fontawesome.css" rel="stylesheet">

        <link href="https://cdn.robotaset.com/assets/thirdparty/bootstrap-datepicker/bootstrap-datepicker.min.css"
            rel="stylesheet">
        <link href="https://cdn.robotaset.com/assets/thirdparty/owl-carousel/css/owl.carousel.css" rel="stylesheet">
        <link href="https://cdn.robotaset.com/assets/thirdparty/owl-carousel/css/owl.theme.default.css" rel="stylesheet">
        <link href="<?php echo e(asset('assets/mobile/custom.css')); ?>" rel="stylesheet">
        <link href="https://cdn.robotaset.com/assets/mobile/sitecss.css?d=1" rel="stylesheet">
        <link href="<?php echo e(general()->warna_mobile); ?>" rel="stylesheet">
        <script src="https://cdn.robotaset.com/assets/js/common/jquery-3.6.0.min.js"></script>
        <script>
            var validationMsg = {
                "alpha": "%s hanya boleh menggunakan abjad",
                "alpha_dash": "%s hanya boleh menggunakan karakter abjad, angka, tanda garis bawah dan penghubung",
                "alpha_numeric": "%s hanya boleh menggunakan abjad dan angka",
                "alpha_numeric_spaces": "%s hanya boleh menggunakan abjad, angka dan spasi",
                "alpha_quote_spaces": "%s hanya boleh menggunakan abjad, tanda petik satu dan spasi",
                "alpha_spaces": "%s hanya boleh menggunakan abjad dan spasi",
                "decimal": "%s harus menggunakan angka desimal",
                "digit": "%s hanya boleh menggunakan digit",
                "digit_no_zero": "%s hanya boleh menggunakan angka dan harus lebih besar dari nol",
                "exact_length": "Panjang %s harus sama %d",
                "greater_than": "%s harus lebih besar dari %d",
                "greater_than_equal_to": "%s harus lebih besar atau sama dengan %d",
                "integer": "%s harus menggunakan angka bulat",
                "less_than": "%s harus kurang dari %d",
                "less_than_equal_to": "%s harus kurang atau sama dengan %d",
                "matches": "%s tidak cocok dengan %s",
                "max_length": "Panjang %s tidak boleh melebihi %d karakter",
                "min_length": "Panjang %s minimal harus %d karakter",
                "is_numeric": "%s hanya boleh menggunakan angka",
                "required": "%s wajib diisi",
                "valid_captcha": "Kode captcha tidak valid",
                "valid_referral": "Kode referral tidak valid"
            };
            var alertMsg = {
                "login_first": "Harap login terlebih dahulu!",
                "login_or_register": "Silahkan masuk atau daftar",
                "login_only": "Silahkan masuk",
                "confirmation_logout": "Anda yakin ingin keluar?",
                "confirmation_calibrate": "Anda yakin ingin menarik saldo dari game?",
                "confirmation_activate_bonus": "Anda yakin ingin mengaktifkan bonus ini?",
                "session_expired": "Sesi login Anda telah berakhir. Harap masuk kembali!",
                "start_end_date_empty": "Tanggal awal dan tanggal akhir tidak boleh kosong!",
                "start_date_is_greater": "Tanggal awal lebih besar dari tanggal akhir",
                "commission_amount": "Komisi harus lebih dari atau sama dengan Rp 10.000",
                "request_failed": "Permintaan gagal, silahkan coba kembali",
                "retry": "Coba lagi",
                "copy_success": "Berhasil menyalin",
                "loading": "Memuat...",
                "varq_confirm_success": "Maaf, tagihan Anda masih menunggu untuk dibayarkan.",
                "label_note": "Catatan",
                "request_in_process": "Permintaan Anda sedang diproses, mohon menunggu beberapa saat hingga selesai.",
                "refno": "No. Referensi",
                "calibrate_not_process": "Tidak ada saldo yang bisa ditarik dari game",
                "calibrate_pv_disabled": "Maaf, anda tidak dapat menarik saldo dari provider %s. Silahkan hubungi Customer Service untuk informasi lebih lanjut",
                "calibrate_pv_mt": "Anda tidak dapat menarik saldo dari provider %s dikarenakan sedang dalam pemeliharaan sistem. Silahkan coba kembali secara berkala.",
                "pv_locked": "Terkunci",
                "varq_confirm_failed": null
            };
        </script>

    <body data-mobile="true">
        <!-- Page Loader -->
        <div class="page-loader" style="display:none;">
            <div class="page-loader-body">
                <img src="https://cdn.robotaset.com/assets/images/common/loader.svg" alt="">Memuat...
            </div>
        </div>
        <div class="wrapper">
            <header>
                <div class="navbar-fixed">
                    <a href="<?php echo e(route('index')); ?>" class="brand-logo"><img src="<?php echo e(env('AWS_URL')); ?><?php echo e(general()->logo); ?>"
                            class="logo-img" alt="<?php echo e(general()->judul); ?>"></a>
                    <ul>
                        <li><a class="button-collapse"><i id="menu_icon">menu icon</i></a></li>
                    </ul>
                </div>
                <!-- Navbar menu -->

                <nav class="side-nav" id="side_nav">
                    <?php if(auth()->guard()->check()): ?>
                        <div class="user-view">
                            <ol>
                                <li><a class="deposit-btn" href="/bank/deposit">Deposit</a></li>
                                <li><a class="withdraw-btn" href="/bank/withdraw">Withdraw</a></li>
                                <li class="float-R"><a class="close-btn"><i class="icon-close" id="icon_close"></i></a></li>
                            </ol>
                            <p>
                                Hai, <span><?php echo e(auth()->user()->username); ?></span>
                            </p>
                            <ul class="member-info ">
                                <li>
                                    <div class="balance">
                                        <a href="#" name="refreshWallet" class="btn-withdraw"><i
                                                class="icon-allwithdraw"></i></a>
                                        <strong><span name="user-creditBalance">
  <?php echo e(number_format(auth()->user()->balance / 1000, 2, '.', '')); ?> K
</span></strong>
                                        <a href="#" name="refreshWallet"><i class="icon-refresh"
                                                id="querymainwallet"></i></a>
                                    </div>
                                    
                                </li>
                            </ul>
                        </div>
                        <ul class="menu-body">
                            <li><a href="/"><i class="icon-home"></i>Beranda</a></li>
                            <li><a href="<?php echo e(route('account.profile')); ?>"><i class="icon-menu-user"></i>Profil</a></li>
                            <li><a href="<?php echo e(route('promotion')); ?>"><i class="fas fa-gift"></i>Bonus</a></li>
                            <li><a href="/bank/history"><i class="icon-transfer"></i>Transfer</a></li>
                            <li><a href="/bank/history"><i class="fas fa-history"></i>Riwayat</a></li>
                            <li class="referral"><a href="/referral"><i
                                        class="icon_referral"></i>Referral</a></li>
                            <li><a href="/game/pgr/3"><i class="fas fa-star"></i>Favorite</a></li>
                            <li><a href="<?php echo e(contact()->id_livechat); ?>" target="_blank"><i class="icon-phone"></i>Hubungi
                                    Kami</a></li>
                            <li>
                                <div class="select-type lang-select">
                                    <i class="icon-translate"></i>
                                    <select id="CurrLanguage" class="language-list">
                                        <option value="en">English</option>
                                        <option value="id" selected="selected">Bahasa Indonesia</option>
                                        <option value="cn">中文</option>
                                    </select>
                                </div>
                            </li>
                            <li><a href="/"><i class="fas fa-arrow-alt-circle-down"></i>Download</a></li>
                            <li><a onclick="confirm_signout();"><i class="fas fa-sign-out-alt"></i>Keluar</a></li>
                        </ul>
                    <?php endif; ?>
                    <?php if(auth()->guard()->guest()): ?>
                        <div class="user-view">
                            <ol>
                                <li><a href="#">Selamat datang</a></li>
                                <li class="float-R"><a class="close-btn"><i class="icon-close" id="icon_close"></i></a></li>
                            </ol>
                            <p>
                                Silahkan masuk atau daftar</p>
                            <ul class="member-btn ">
                                <li><a class="btn btn-secondary-primary" href="<?php echo e(route('login.form')); ?>">Masuk</a></li>
                                <li><a class="btn btn-join" href="<?php echo e(route('login.register')); ?>">Daftar</a></li>
                            </ul>
                        </div>
                        <ul class="menu-body">
                            <li><a href="<?php echo e(route('index')); ?>"><i class="icon-home"></i>Beranda</a></li>
                            <li><a href="<?php echo e(contact()->id_livechat); ?>" target="_blank"><i class="icon-phone"></i>Hubungi
                                    Kami</a></li>
                            <li>
                                <div class="select-type lang-select">
                                    <i class="icon-translate"></i>
                                    <select id="CurrLanguage" class="language-list">
                                        <option value="en">English</option>
                                        <option value="id" selected="selected">Bahasa Indonesia</option>
                                        <option value="cn">简体中文</option>
                                    </select>
                                </div>
                            </li>
                            <li><a href="#"><i class="fas fa-arrow-alt-circle-down"></i>Download</a></li>
                        </ul>
                    <?php endif; ?>
                    <!--#endregion -->
                </nav>
                <div id="sidenav_overlay"></div>
            </header>
            <script>
                $(".language-list").on("change", function() {
                    var _this = $(this);
                    var lang = _this.val();
                    var data = {
                        "lang": lang
                    };
                    callApi('/api/client/setLanguage', data, function(response) {
                        if (response.success == true) {
                            // 				window.location.reload();
                            redirectPage();
                        } else {
                            alert(alertMsg.request_failed);
                        }
                    });
                });
            </script>
            <main class="clearfix">
                <?php echo $__env->yieldContent('content'); ?>

            </main>

            <div class="bottom-nav-bar" id="bottom-nav-bar">
                <ul>
                    <li><a onclick="window.history.go(-1); return false;"><i class="fas fa-angle-left"></i>Kembali</a>
                    </li>
                    <li><a href="<?php echo e(route('bank.account')); ?>" id="Financial"
                            class="<?php echo e(request()->routeIs('bank*') ? 'active' : ''); ?>"><i class="icon-Financial"></i>Akun
                            Saya</a></li>
                    <li><a href="<?php echo e(route('promotion')); ?>" id="Promotions"
                            class="<?php echo e(request()->routeIs('promotion') ? 'active' : ''); ?>"><i
                                class="icon-promos"></i>Promosi</a></li>
                    <li><a href="<?php echo e(contact()->id_livechat); ?>" target="_blank" id="Contact"><i
                                class="icon-live-chet"></i>Live Chat</a></li>
                    <li><a href="<?php echo e(route('index')); ?>" id="Home"
                            class="<?php echo e(request()->routeIs('index') ? 'active' : ''); ?>"><i
                                class="icon-home"></i>Beranda</a>
                    </li>
                </ul>
            </div>
        </div>

        <div class="pageTop-element" id="pagetop" style="display: none;">
            <i class="icon-angle-up"></i>
            <span>Atas</span>
        </div>

        <script src="https://cdn.robotaset.com/assets/js/common/axios.min.js"></script>
        <script src="https://cdn.robotaset.com/assets/mobile/basejs.js"></script>
        <script src="https://cdn.robotaset.com/assets/thirdparty/owl-carousel/owl.carousel.js"></script>
        <script src="https://cdn.robotaset.com/assets/js/common/bootstrap.min.js" type="text/javascript"></script>
        <script src="https://cdn.robotaset.com/assets/js/common/ajaxcall.js"></script>
        <script src="https://cdn.robotaset.com/assets/js/common/format-number.js"></script>
        <script src="https://cdn.robotaset.com/assets/js/common/240715_app.js"></script>
        <script src="https://cdn.robotaset.com/assets/mobile/jsbridge.js"></script>
        <script src="https://cdn.robotaset.com/assets/thirdparty/bootstrap-datepicker/bootstrap-datepicker.min.js"></script>

        <?php if(auth()->guard()->check()): ?>
            <script>
                var jpEl = $("#jackpot");
                if (jpEl.length == 1) {
                    setInterval(function() {
                        var newJp = new Date().getTime() / 100;
                        jpEl.attr("data-value", newJp);
                        jpEl.text(formatCurrency(newJp, null, 2));
                    }, 600);
                }

                $(document).on("click", ".open-game", function(e) {
                    e.preventDefault();


                    var _this = $(this);
                    var target = _this.data("href");


                    window.open(target, '_blank');

                });

                function reloadBalance() {
                    $.ajax({
                        type: "POST",
                        url: "<?php echo e(route('api.balance')); ?>",
                        data: {
                            _token: "<?php echo e(csrf_token()); ?>"
                        },
                        success: function(response) {
                            if (response.success == true) {
                                $('span[name*=mainBalance]').text(response.balance);
                                setLoading(false);
                            }
                        }
                    });
                }



                reloadBalance();
                $("a[name=refreshWallet]").on("click", function(e) {
                    e.preventDefault();
                    setLoading(true);
                    reloadBalance();
                })

                function setLoading(isSet) {
                    var loader = $(".page-loader");
                    isSet == true ? loader.show() : loader.hide();
                }
            </script>
        <?php endif; ?>

        <?php if(auth()->guard()->guest()): ?>
            <script>
                var jpEl = $("#jackpot");
                if (jpEl.length == 1) {
                    setInterval(function() {
                        var newJp = new Date().getTime() / 100;
                        jpEl.attr("data-value", newJp);
                        jpEl.text(formatCurrency(newJp, null, 2));
                    }, 600);
                }



                $(document).on("click", ".open-game", function(e) {
                    e.preventDefault();


                    alert(alertMsg.login_first);
                    return false;

                });
            </script>
        <?php endif; ?>

        <style>
        </style>
        <script>
            function getIconEventTag(gmsbevent) {
                var stylingTag = ""; //"right:-150%";
                var eventTag = "";
                if (gmsbevent === 1) {
                    eventTag = '<img alt="hot" width="100%" class="game-icon-frame" style="' + stylingTag + '" src="' + assets +
                        '/images/provider/pp-hot-tag-w-frame.png">';
                } else if (gmsbevent === 2) {
                    eventTag = '<img alt="new" width="100%" class="game-icon-frame" style="' + stylingTag + '" src="' + assets +
                        '/images/provider/pp-new-tag-w-frame.png">';
                } else if (gmsbevent === 3) {
                    eventTag = '<img alt="exl" width="100%" class="game-icon-frame" style="' + stylingTag + '" src="' + assets +
                        '/images/provider/pp-excl-tag.png">';
                }
                return eventTag;
            }
        </script>
        <script>
            $(function() {
                var isMobile = true;
                var mobileNumberLabel = "Nomor Telepon";
                var fullNameLabel = "Nama Lengkap";

                /*
                var dpQrType = '';
                var dpWalletRedir = '';

                if (dpQrType === 'HTTP_WEB' && dpWalletRedir !== '') {
                    setTimeout(function () {
                        window.location.href = dpWalletRedir;
                    }, 2000);
                    return;
                }
                */

                $(document).on("change", "#TransferTo", function(e) {
                    e.preventDefault();
                    var transferCode = $("#TransferTo").find('option:selected').attr("code");
                    var isDepositWallet = /^wallet/.test(transferCode);
                    if (isDepositWallet) {
                        renderWalletInput();
                    } else {
                        removeWalletInput();
                    }
                });

                $(document).on('input', '#Phone', function() {
                    if ($(this).val().length > 14) {
                        $(this).val($(this).val().slice(0, 14));
                        return;
                    }
                    $(this).val($(this).val().replace(/[^0-9]/g, ''));
                });

                function renderWalletInput() {
                    if (isMobile) {
                        $(document).find('#TransferTo').after('<div class="wallet-input">' +
                            '<div class="textfield-wrap">' +
                            '<label for="Phone">' + mobileNumberLabel + '</label>' +
                            '<div class="input-field">' +
                            '<input type="text" id="Phone" name="Phone" value="">' +
                            '</div>' +
                            '</div>' +
                            '<div class="textfield-wrap">' +
                            '<label for="FullName">' + fullNameLabel + '</label>' +
                            '<div class="input-field">' +
                            '<input type="text" id="FullName" name="FullName" value="">' +
                            '</div>' +
                            '</div>' +
                            '</div>');
                    } else {
                        $(document).find('#TransferTo').after('<div class="clearfix wallet-input">' +
                            '<label for="Phone">' + mobileNumberLabel + '<span>*</span></label>' +
                            '<div class="form_group_category textfield-wrap">' +
                            '<input type="text" onkeydown="return digits(event)" id="Phone" name="Phone" required="required" placeholder="08xx">' +
                            '<span class="tooltip" data-area="message"></span>' +
                            '</div>' +
                            '</div>' +
                            '<div class="clearfix wallet-input">' +
                            '<label for="FullName">' + fullNameLabel + '<span>*</span></label>' +
                            '<div class="form_group_category textfield-wrap">' +
                            '<input type="text" id="FullName" name="FullName" required="required">' +
                            '<span class="tooltip" data-area="message"></span>' +
                            '</div>' +
                            '</div>');
                    }
                }

                function removeWalletInput() {
                    $(document).find('.wallet-input').remove();
                }
            });
        
        </script>
        <script>
function updateBalance() {
    fetch("<?php echo e(route('api.balance')); ?>")
        .then(response => response.json())
        .then(data => {
            if (data.balance !== undefined) {
                const formatted = (data.balance / 1000).toFixed(2);
                document.getElementById("user-creditBalance").textContent = formatted;
            }
        })
        .catch(error => console.error('Error:', error));
}

// Jalankan langsung saat halaman dimuat
updateBalance();

// Interval tiap 3 detik
setInterval(updateBalance, 3000);
</script>
        <?php echo $__env->yieldPushContent('addon-mobile'); ?>;
        

    </html>
<?php endif; ?>

<?php if(!app('mobile-detect')->isMobile()) : ?>

    <?php if(request()->routeIs('bank.*')): ?>
    <?php echo $__env->make('frontend.layouts.desktop2', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php elseif(request()->routeIs('account.*')): ?>
    <?php echo $__env->make('frontend.layouts.desktop3', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php else: ?>
    <?php echo $__env->make('frontend.layouts.desktop', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php endif; ?>
<?php endif; ?>
<?php /**PATH /home/infiny.idr.onl/public_html/core/resources/views/frontend/layouts/main.blade.php ENDPATH**/ ?>