

<?php $__env->startSection('panel'); ?>
<h4 class="fw-bold py-3 mb-3">History Taruhan Member</h4>

<div class="card">
    <div class="card-body">
        <a href="<?php echo e(route('admin.lottery.manage')); ?>" class="btn btn-secondary btn-sm mb-3">Kembali ke Manage Pasaran</a>

        <table class="table table-bordered table-sm" id="history-table">
            <thead class="table-dark">
                <tr>
                    <th>#</th>
                    <th>Username</th>
                    <th>Pasaran</th>
                    <th>Pasang</th>
                    <th>Amount</th>
                    <th>Amount Bet</th>
                    <th>Tanggal</th>
                    <th>Win</th>
                    <th>Status</th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $taruhans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $t): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td><?php echo e($loop->iteration); ?></td>
                    <td><?php echo e($t->username); ?></td>
                    <td><?php echo e($t->market); ?></td>
                    <td><?php echo e($t->pasang); ?></td>
                    <td><?php echo e($t->amount); ?></td>
                    <td><?php echo e($t->amount_bet); ?></td>
                    <td><?php echo e($t->date); ?></td>
                    <td><?php echo e($t->win); ?></td>
                    <td>
                        <?php if($t->status == '0'): ?>
                            <span class="badge bg-danger">Kalah</span>
                        <?php elseif($t->status == '1'): ?>
                            <span class="badge bg-primary">Menunggu</span>
                        <?php elseif($t->status == '2'): ?>
                            <span class="badge bg-success">Sukses</span>
                        <?php else: ?>
                            <span class="badge bg-secondary"><?php echo e($t->status); ?></span>
                        <?php endif; ?>
                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
<script>
$(function(){
    $('#history-table').DataTable({
        lengthMenu:[[25,50,100,-1],[25,50,100,"All"]],
        order:[[6,'desc']],
        columnDefs:[{className:'text-center',targets:'_all'}]
    });
});
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('backend.layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/infiny.idr.onl/public_html/core/resources/views/backend/lottery/history.blade.php ENDPATH**/ ?>