<?php $__env->startSection('panel'); ?>
    <div class="row">
        <div class="col-lg-4">
            <?php if(Route::is('admin.settings.contact_edit')): ?>
                <div class="card">
                    <div class="card-body">
                        <h4 class="card-title">Contact Edit</h4>
                        <form class="form p-t-20" method="POST" action="<?php echo e(route('admin.settings.update_contact',$contacts->id)); ?>" enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>
                            <div class="form-group mb-3">
                                <label>Icon</label>
                                <select name="icon" class="form-control select2" required>
                                    <option value="live-chat" <?php echo e($contacts->icon == 'live-chat' ? 'selected' : ''); ?>> Livechat </option>
                                    <option value="whatsapp" <?php echo e($contacts->icon == 'whatsapp' ? 'selected' : ''); ?>> WhatsApp </option>
                                    <option value="messenger" <?php echo e($contacts->icon == 'messenger' ? 'selected' : ''); ?>> Facebook </option>
                                    <option value="email" <?php echo e($contacts->icon == 'email' ? 'selected' : ''); ?>> Email </option>
                                    <option value="telegram" <?php echo e($contacts->icon == 'telegram' ? 'selected' : ''); ?>> Telegram </option>
                                    <option value="contact-number" <?php echo e($contacts->icon == 'contact-number' ? 'selected' : ''); ?>> Phone </option>
                                </select>
                            </div>
                            <div class="form-group">
                                <label>Title</label>
                                <div class="input-group mb-3">
                                    <input type="text" name="title" class="form-control" placeholder="Title"
                                        required="" aria-label="Title" aria-describedby="basic-addon11" value="<?php echo e($contacts->title); ?>" required>
                                </div>
                            </div>
                            <div class="form-group">
                                <label>Url</label>
                                <div class="input-group mb-3">
                                    <input type="text" name="url" class="form-control"
                                        placeholder="Url" required="" aria-label="url"
                                        aria-describedby="basic-addon11" value="<?php echo e($contacts->url); ?>" required>
                                </div>
                            </div>
                            <button type="submit" class="btn btn-primary m-r-10">Update</button>
                        </form>
                    </div>
                </div>
            <?php else: ?>
                <div class="card">
                    <div class="card-body">
                        <h4 class="card-title">Contact Create</h4>
                        <form class="form p-t-20" method="POST" action="<?php echo e(route('admin.settings.create_contact')); ?>" enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>
                            <div class="form-group mb-3">
                                <label>Icon</label>
                                <select name="icon" class="form-control select2" required>
                                    <option value=""> Select Icon </option>
                                    <option value="live-chat"> Livechat </option>
                                    <option value="whatsapp"> WhatsApp </option>
                                    <option value="messenger"> Facebook </option>
                                    <option value="email"> Email </option>
                                    <option value="telegram"> Telegram </option>
                                    <option value="contact-number"> Phone </option>
                                </select>
                            </div>
                            <div class="form-group">
                                <label>Title</label>
                                <div class="input-group mb-3">
                                    <input type="text" name="title" class="form-control" placeholder="Title"
                                        required="" aria-label="Title" aria-describedby="basic-addon11" required>
                                </div>
                            </div>
                            <div class="form-group">
                                <label>Url</label>
                                <div class="input-group mb-3">
                                    <input type="text" name="url" class="form-control"
                                        placeholder="Url" required="" aria-label="url"
                                        aria-describedby="basic-addon11" required>
                                </div>
                            </div>
                            <button type="submit" class="btn btn-primary m-r-10">Submit</button>
                        </form>
                    </div>
                </div>
            <?php endif; ?>
        </div>
        <div class="col-lg-8">
            <div class="card">
                <div class="card-body">
                    <h4 class="card-title">Contact List</h4>
                </div>
                <div class="card-datatable table-responsive">
                    <table id="default-datatable" class="table table-bordered table-sm">
                        <thead>
                            <tr>
                                <th class="text-center" style="vertical-align: middle; font-size: 12px;">#</th>
                                <th class="text-center" style="vertical-align: middle; font-size: 12px;">Icon</th>
                                <th class="text-center" style="vertical-align: middle; font-size: 12px;">Title</th>
                                <th class="text-center" style="vertical-align: middle; font-size: 12px;">Url</th>
                                <th class="text-center" style="vertical-align: middle; font-size: 12px;">Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $contact; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <th class="text-center" style="vertical-align: middle; font-size: 13px;"><?php echo e($loop->iteration); ?></th>
                                    <td class="text-center"
                                        style="vertical-align: middle; white-space: normal; font-size: 13px;"><?php echo e($item->icon); ?>

                                    </td>
                                    <td class="text-center"
                                        style="vertical-align: middle; white-space: normal; font-size: 13px;"><?php echo e($item->title); ?>

                                    </td>
                                    <td class="text-center"
                                        style="vertical-align: middle; white-space: normal; font-size: 13px;"><?php echo e($item->url); ?>

                                    </td>
                                    <td class="text-center" style="vertical-align: middle; font-size: 13px;">
                                        <a href="<?php echo e(route('admin.settings.contact_edit',$item->id)); ?>" class="btn btn-xs btn-primary"><span
                                                class="mdi mdi-pencil"></span></a>
                                        <a href="<?php echo e(route('admin.settings.contact_delete',$item->id)); ?>" class="btn btn-xs btn-danger"
                                            onclick="return confirm('Are you sure want to delete this contacts?');"><span
                                                class="mdi mdi-trash-can"></span></a>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/zxtmtoay/taxi338.link-ofc.xyz/core/resources/views/backend/settings/contact.blade.php ENDPATH**/ ?>