<?php $__env->startSection('panel'); ?>
    <h4 class="fw-bold py-3 mb-3">
        Withdraw Pending
    </h4>

    <div class="row">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-datatable table-responsive">
                    <table id="default-datatable" class="table table-bordered table-sm">
                        <thead>
                            <tr>
                                <th class="text-center" style="vertical-align: middle; font-size: 12px;">#</th>
                                <th class="text-center" style="vertical-align: middle; font-size: 12px;">Trx ID</th>
                                <th class="text-center" style="vertical-align: middle; font-size: 12px;">Username</th>
                                <th class="text-center" style="vertical-align: middle; font-size: 12px;">Amount</th>
                                <th class="text-center" style="vertical-align: middle; font-size: 12px;">Bank Users</th>
                                <th class="text-center" style="vertical-align: middle; font-size: 12px;">Note</th>
                                <th class="text-center" style="vertical-align: middle; font-size: 12px;">Date</th>
                                <th class="text-center" style="vertical-align: middle; font-size: 12px;">Status</th>
                                <th class="text-center" style="vertical-align: middle; font-size: 12px;">Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $transaction; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $trx): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td class="text-center"
                                        style="vertical-align: middle; white-space: normal; font-size: 13px;">
                                        <?php echo e($loop->iteration); ?></td>
                                    <td class="text-center"
                                        style="vertical-align: middle; white-space: normal; font-size: 13px;">
                                        <?php echo e($trx->trx_id); ?></td>
                                    <td class="text-center"
                                        style="vertical-align: middle; white-space: normal; font-size: 13px;">
                                        <?php echo e($trx->username); ?></td>
                                    <td class="text-center"
                                        style="vertical-align: middle; white-space: normal; font-size: 13px;">
                                        <?php echo e(number_format($trx->total, 2)); ?></td>
                                    <td class="text-center"
                                        style="vertical-align: middle; white-space: normal; font-size: 13px;">
                                        <?php if(auth()->guard('admin')->user()->level == 'admin'): ?>
                                        <?php echo e(censor($trx->dari_bank,4)); ?>

                                        <?php else: ?>
                                        <?php echo e($trx->dari_bank); ?>

                                        <?php endif; ?>
                                        </td>
                                    <td class="text-center"
                                        style="vertical-align: middle; white-space: normal; font-size: 13px;">
                                        <?php echo e($trx->keterangan); ?></td>
                                    <td class="text-center"
                                        style="vertical-align: middle; white-space: normal; font-size: 13px;">
                                        <?php echo e($trx->created_at); ?></td>
                                    <td class="text-center"
                                        style="vertical-align: middle; white-space: normal; font-size: 13px;">
                                        <?php if($trx->status == 'Pending'): ?>
                                            <span class="badge bg-label-warning rounded-pill">Pending</span>
                                        <?php elseif($trx->status == 'Ditolak'): ?>
                                            <span class="badge bg-label-danger rounded-pill">Rejected</span>
                                        <?php else: ?>
                                            <span class="badge bg-label-success rounded-pill">Active</span>
                                        <?php endif; ?>
                                    </td>
                                    <td class="text-center"
                                        style="vertical-align: middle; white-space: normal; font-size: 13px;">
                                        <a href="<?php echo e(route('admin.withdrawal.approve',$trx->id)); ?>" class="btn btn-success btn-sm"
                                            onclick="return confirm('Are you sure want to Confirm this Transaction?');">Approve</a>
                                        <a href="<?php echo e(route('admin.withdrawal.reject',$trx->id)); ?>" class="btn btn-danger btn-sm"
                                            onclick="return confirm('Are you sure want to Reject this Transaction?');">Reject</a>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend..layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /www/wwwroot/infiny-lara.demo-api.xyz/core/resources/views/backend/withdraw/pending.blade.php ENDPATH**/ ?>