<?php $__env->startSection('content'); ?>
    <div class="page-header-title">
        <h3>Bank</h3>
    </div>
    <div class="account-structure">
        <ul class="account-menu" id="account_menu">
            <li><a href="/bank/account" class="active">Akun Saya</a></li>
            <li><a href="/bank/deposit">Deposit</a></li>
            <li><a href="/bank/history">History</a></li>
            <li><a href="/bank/withdraw">Withdraw</a></li>
        </ul>
    </div>
    <?php if(auth()->user()->nama_bank == 'notset'): ?>
        <div class="info-page-content"
            data-banklist='[{"id":1,"name":"BCA","st":1,"eligible":1,"admperm":0,"code":"bca","autowd":0,"accnomnlgth":10,"accnomxlgth":10,"maxpldp":100000.0000},{"id":2,"name":"BNI","st":1,"eligible":1,"admperm":0,"code":"bni","autowd":0,"accnomnlgth":9,"accnomxlgth":10,"maxpldp":100000.0000},{"id":3,"name":"BRI","st":1,"eligible":1,"admperm":0,"code":"bri","autowd":0,"accnomnlgth":14,"accnomxlgth":15,"maxpldp":100000.0000},{"id":4,"name":"Mandiri","st":1,"eligible":1,"admperm":0,"code":"mandiri","autowd":0,"accnomnlgth":11,"accnomxlgth":13,"maxpldp":100000.0000},{"id":5,"name":"CIMB Niaga","st":1,"eligible":1,"admperm":0,"code":"cimb","autowd":0,"accnomnlgth":12,"accnomxlgth":13,"maxpldp":100000.0000},{"id":6,"name":"Danamon","st":1,"eligible":1,"admperm":0,"code":"danamon","autowd":0,"accnomnlgth":10,"accnomxlgth":12,"maxpldp":100000.0000},{"id":7,"name":"Permata","st":1,"eligible":1,"admperm":0,"code":"permata","autowd":0,"accnomnlgth":9,"accnomxlgth":16,"maxpldp":100000.0000},{"id":8,"name":"OVO","st":1,"eligible":1,"admperm":0,"code":"ovo","autowd":0,"accnomnlgth":10,"accnomxlgth":13,"maxpldp":100000.0000},{"id":9,"name":"Gopay","st":1,"eligible":1,"admperm":0,"code":"gopay","autowd":0,"accnomnlgth":10,"accnomxlgth":13,"maxpldp":100000.0000},{"id":12,"name":"Dana","st":1,"eligible":1,"admperm":0,"code":"dana","autowd":0,"accnomnlgth":10,"accnomxlgth":15,"maxpldp":100000.0000},{"id":13,"name":"Panin","st":1,"eligible":1,"admperm":0,"code":"panin","autowd":0,"accnomnlgth":10,"accnomxlgth":13,"maxpldp":100000.0000},{"id":14,"name":"LinkAja","st":1,"eligible":1,"admperm":0,"code":"linkaja","autowd":0,"accnomnlgth":10,"accnomxlgth":13,"maxpldp":100000.0000},{"id":16,"name":"Sakuku","st":1,"eligible":1,"admperm":0,"code":"sakuku","autowd":0,"accnomnlgth":10,"accnomxlgth":13,"maxpldp":100000.0000},{"id":49,"name":"BSI","st":1,"eligible":1,"admperm":0,"code":"bsi","autowd":0,"accnomnlgth":10,"accnomxlgth":10,"maxpldp":100000.0000},{"id":82,"name":"Jenius","st":1,"eligible":1,"admperm":0,"code":"jenius","autowd":0,"accnomnlgth":10,"accnomxlgth":13,"maxpldp":100000.0000},{"id":83,"name":"Neobank","st":1,"eligible":1,"admperm":0,"code":"neo","autowd":0,"accnomnlgth":10,"accnomxlgth":16,"maxpldp":100000.0000},{"id":115,"name":"Jago","st":1,"eligible":1,"admperm":0,"code":"jago","autowd":0,"accnomnlgth":12,"accnomxlgth":12,"maxpldp":10000.0000},{"id":148,"name":"Sinarmas","st":1,"eligible":1,"admperm":0,"code":"sinarmas","autowd":0,"accnomnlgth":10,"accnomxlgth":13,"maxpldp":100000.0000},{"id":149,"name":"Allobank","st":1,"eligible":1,"admperm":0,"code":"allo","autowd":0,"accnomnlgth":10,"accnomxlgth":13,"maxpldp":100000.0000},{"id":151,"name":"Blu by BCA Digital","st":1,"eligible":1,"admperm":0,"code":"blu","autowd":0,"accnomnlgth":10,"accnomxlgth":12,"maxpldp":10000.0000},{"id":152,"name":"Seabank","st":1,"eligible":1,"admperm":0,"code":"seabank","autowd":0,"accnomnlgth":10,"accnomxlgth":13,"maxpldp":100000.0000},{"id":153,"name":"OCBC","st":1,"eligible":1,"admperm":0,"code":"ocbc","autowd":0,"accnomnlgth":10,"accnomxlgth":13,"maxpldp":100000.0000}]'
            data-default='{"id":1,"name":"BCA","st":1,"eligible":1,"admperm":0,"code":"bca","autowd":0,"accnomnlgth":10,"accnomxlgth":10,"maxpldp":100000.0000}'>
            <div class="account-content">
                <div class="default-wrap">
                    <?php if(session('success')): ?>
                        <div id="Alert" class="alert alert-success alert-dismissible fade show" role="alert">
                            <?php echo e(session('success')); ?><button type="button" class="close" data-dismiss="alert"
                                aria-label="Close">
                                <span aria-hidden="true">×</span>
                            </button>
                        </div>
                    <?php endif; ?>

                    <?php if(session('error')): ?>
                        <div id="Alert" class="alert alert-warning alert-dismissible fade show" role="alert">
                            <?php echo e(session('error')); ?><button type="button" class="close" data-dismiss="alert"
                                aria-label="Close">
                                <span aria-hidden="true">×</span>
                            </button>
                        </div>
                    <?php endif; ?>

                    <div id="Alert" class="alert  " role="alert" style="display: none;">
                    </div>
                    <form id="BankForm" class="bank-form" action="/bank/setAccount" method="POST">
                        <?php echo csrf_field(); ?>
                        <div class="textfield-wrap">
                            <label for="BankName">Nama Bank<span>*</span></label>
                            <div class="select-type browser-default">
                                <select name="BankName" id="BankName" required="required">
                                    <option value="bca" selected="selected">BCA</option>
                                    <option value="bni">BNI</option>
                                    <option value="bri">BRI</option>
                                    <option value="mandiri">Mandiri</option>
                                    <option value="cimb">CIMB Niaga</option>
                                    <option value="danamon">Danamon</option>
                                    <option value="permata">Permata</option>
                                    <option value="ovo">OVO</option>
                                    <option value="gopay">Gopay</option>
                                    <option value="dana">Dana</option>
                                    <option value="panin">Panin</option>
                                    <option value="linkaja">LinkAja</option>
                                    <option value="sakuku">Sakuku</option>
                                    <option value="bsi">BSI</option>
                                    <option value="jenius">Jenius</option>
                                    <option value="neo">Neobank</option>
                                    <option value="jago">Jago</option>
                                    <option value="sinarmas">Sinarmas</option>
                                    <option value="allo">Allobank</option>
                                    <option value="blu">Blu by BCA Digital</option>
                                    <option value="seabank">Seabank</option>
                                    <option value="ocbc">OCBC</option>
                                </select>
                            </div>
                        </div>
                        <div class="textfield-wrap">
                            <label for="AccountNo">Nomor Rekening Bank<span>*</span></label>
                            <div class="input-field browser-default">
                                <input type="number" name="AccountNo" id="AccountNo"
                                    onKeyPress="if(this.value.length==this.maxLength) return false;"
                                    onkeydown="return digits(event)" maxlength="17" required="required" autocomplete="off"
                                    autofocus="autofocus">
                                <i class="fas fa-times-circle"></i>
                            </div>
                            <span class="tooltip" data-area="message"></span>
                        </div>
                        <div class="textfield-wrap">
                            <label for="AccountName">Nama Rekening<span>*</span></label>
                            <div class="input-field browser-default">
                                <input type="text" name="AccountName" id="AccountName" required="required"
                                    autocomplete="off">
                                <i class="fas fa-times-circle"></i>
                            </div>
                            <span class="tooltip" data-area="message"></span>
                        </div>

                        <input type="hidden" id="Accminlgth" name="Accminlgth" value=''>
                        <input type="hidden" id="Accmaxlgth" name="Accmaxlgth" value=''>
                        <button class="btn-primary" type="reset" id="BankReset">Ulangi</button>
                        <button class="btn-primary" type="submit" id="BankSubmit">Kirim</button>
                    </form>
                </div>
            </div>
        </div>
    <?php else: ?>
        <div class="info-page-content" data-banklist='' data-default=''>
            <div class="account-content">
                <div class="default-wrap">
                    <div id="Alert" class="alert  " role="alert" style="display: none;">
                    </div>
                    <div class="textfield-wrap">
                        <label for="BankName">Nama Bank</label>
                        <div class="input-field browser-default">
                            <input type="text" id="BankName" value="<?php echo e(strtoupper(auth()->user()->nama_bank)); ?>"
                                readonly="readonly">
                        </div>
                    </div>
                    <div class="textfield-wrap">
                        <label for="AccountNo">Nomor Rekening Bank</label>
                        <div class="input-field browser-default">
                            <input type="text" id="AccountNo" value="<?php echo e(censor(auth()->user()->nomor_rekening, 4)); ?>"
                                readonly="readonly">
                        </div>
                    </div>
                    <div class="textfield-wrap">
                        <label for="AccountName">Nama Rekening</label>
                        <div class="input-field browser-default">
                            <input type="text" id="AccountName" value="<?php echo e(censor(auth()->user()->nama_lengkap, 4)); ?>"
                                readonly="readonly">
                        </div>
                    </div>

                </div>
            </div>
        </div>
    <?php endif; ?>

    <script src="https://cdn.robotaset.com/assets/js/pages/Bank.js"></script>
    <script src="https://cdn.robotaset.com/assets/js/pages/bankaccount.js"></script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('account'); ?>
    <?php if(auth()->user()->nama_bank == 'notset'): ?>
        <div class="row con_box">
            <div class="account_main info-page-content"
                data-banklist='[{"id":1,"name":"BCA","st":1,"eligible":1,"admperm":0,"code":"bca","autowd":0,"accnomnlgth":10,"accnomxlgth":10,"maxpldp":100000.0000},{"id":2,"name":"BNI","st":1,"eligible":1,"admperm":0,"code":"bni","autowd":0,"accnomnlgth":9,"accnomxlgth":10,"maxpldp":100000.0000},{"id":3,"name":"BRI","st":1,"eligible":1,"admperm":0,"code":"bri","autowd":0,"accnomnlgth":14,"accnomxlgth":15,"maxpldp":100000.0000},{"id":4,"name":"Mandiri","st":1,"eligible":1,"admperm":0,"code":"mandiri","autowd":0,"accnomnlgth":11,"accnomxlgth":13,"maxpldp":100000.0000},{"id":5,"name":"CIMB Niaga","st":1,"eligible":1,"admperm":0,"code":"cimb","autowd":0,"accnomnlgth":12,"accnomxlgth":13,"maxpldp":100000.0000},{"id":6,"name":"Danamon","st":1,"eligible":1,"admperm":0,"code":"danamon","autowd":0,"accnomnlgth":10,"accnomxlgth":12,"maxpldp":100000.0000},{"id":7,"name":"Permata","st":1,"eligible":1,"admperm":0,"code":"permata","autowd":0,"accnomnlgth":9,"accnomxlgth":16,"maxpldp":100000.0000},{"id":8,"name":"OVO","st":1,"eligible":1,"admperm":0,"code":"ovo","autowd":0,"accnomnlgth":10,"accnomxlgth":13,"maxpldp":100000.0000},{"id":9,"name":"Gopay","st":1,"eligible":1,"admperm":0,"code":"gopay","autowd":0,"accnomnlgth":10,"accnomxlgth":13,"maxpldp":100000.0000},{"id":12,"name":"Dana","st":1,"eligible":1,"admperm":0,"code":"dana","autowd":0,"accnomnlgth":10,"accnomxlgth":15,"maxpldp":100000.0000},{"id":13,"name":"Panin","st":1,"eligible":1,"admperm":0,"code":"panin","autowd":0,"accnomnlgth":10,"accnomxlgth":13,"maxpldp":100000.0000},{"id":14,"name":"LinkAja","st":1,"eligible":1,"admperm":0,"code":"linkaja","autowd":0,"accnomnlgth":10,"accnomxlgth":13,"maxpldp":100000.0000},{"id":16,"name":"Sakuku","st":1,"eligible":1,"admperm":0,"code":"sakuku","autowd":0,"accnomnlgth":10,"accnomxlgth":13,"maxpldp":100000.0000},{"id":49,"name":"BSI","st":1,"eligible":1,"admperm":0,"code":"bsi","autowd":0,"accnomnlgth":10,"accnomxlgth":10,"maxpldp":100000.0000},{"id":82,"name":"Jenius","st":1,"eligible":1,"admperm":0,"code":"jenius","autowd":0,"accnomnlgth":10,"accnomxlgth":13,"maxpldp":100000.0000},{"id":83,"name":"Neobank","st":1,"eligible":1,"admperm":0,"code":"neo","autowd":0,"accnomnlgth":10,"accnomxlgth":16,"maxpldp":100000.0000},{"id":115,"name":"Jago","st":1,"eligible":1,"admperm":0,"code":"jago","autowd":0,"accnomnlgth":12,"accnomxlgth":12,"maxpldp":10000.0000},{"id":148,"name":"Sinarmas","st":1,"eligible":1,"admperm":0,"code":"sinarmas","autowd":0,"accnomnlgth":10,"accnomxlgth":13,"maxpldp":100000.0000},{"id":149,"name":"Allobank","st":1,"eligible":1,"admperm":0,"code":"allo","autowd":0,"accnomnlgth":10,"accnomxlgth":13,"maxpldp":100000.0000},{"id":151,"name":"Blu by BCA Digital","st":1,"eligible":1,"admperm":0,"code":"blu","autowd":0,"accnomnlgth":10,"accnomxlgth":12,"maxpldp":10000.0000},{"id":152,"name":"Seabank","st":1,"eligible":1,"admperm":0,"code":"seabank","autowd":0,"accnomnlgth":10,"accnomxlgth":13,"maxpldp":100000.0000},{"id":153,"name":"OCBC","st":1,"eligible":1,"admperm":0,"code":"ocbc","autowd":0,"accnomnlgth":10,"accnomxlgth":13,"maxpldp":100000.0000}]'
                data-default='{"id":1,"name":"BCA","st":1,"eligible":1,"admperm":0,"code":"bca","autowd":0,"accnomnlgth":10,"accnomxlgth":10,"maxpldp":100000.0000}'>
                <?php if(session('success')): ?>
                    <div id="Alert" class="alert alert-success alert-dismissible fade show" role="alert">
                        <?php echo e(session('success')); ?><button type="button" class="close" data-dismiss="alert"
                            aria-label="Close">
                            <span aria-hidden="true">×</span>
                        </button>
                    </div>
                <?php endif; ?>

                <?php if(session('error')): ?>
                    <div id="Alert" class="alert alert-warning alert-dismissible fade show" role="alert">
                        <?php echo e(session('error')); ?><button type="button" class="close" data-dismiss="alert"
                            aria-label="Close">
                            <span aria-hidden="true">×</span>
                        </button>
                    </div>
                <?php endif; ?>
                <div id="Alert" class="alert  " role="alert" style="display: none;">
                </div>
                <div class="con_item" style="display: block;">
                    <h4>Akun Bank</h4>

                    <form id="BankForm" class="bank-form" action="/bank/setAccount" method="POST">
                        <?php echo csrf_field(); ?>
                        <div class="form-group">
                            <label for="BankName">Nama Bank<span>*</span></label>
                            <div class="form_group_category textfield-wrap">
                                <select name="BankName" id="BankName" required="required">
                                    <option value="bca" selected="selected">BCA</option>
                                    <option value="bni">BNI</option>
                                    <option value="bri">BRI</option>
                                    <option value="mandiri">Mandiri</option>
                                    <option value="cimb">CIMB Niaga</option>
                                    <option value="danamon">Danamon</option>
                                    <option value="permata">Permata</option>
                                    <option value="ovo">OVO</option>
                                    <option value="gopay">Gopay</option>
                                    <option value="dana">Dana</option>
                                    <option value="panin">Panin</option>
                                    <option value="linkaja">LinkAja</option>
                                    <option value="sakuku">Sakuku</option>
                                    <option value="bsi">BSI</option>
                                    <option value="jenius">Jenius</option>
                                    <option value="neo">Neobank</option>
                                    <option value="jago">Jago</option>
                                    <option value="sinarmas">Sinarmas</option>
                                    <option value="allo">Allobank</option>
                                    <option value="blu">Blu by BCA Digital</option>
                                    <option value="seabank">Seabank</option>
                                    <option value="ocbc">OCBC</option>
                                </select>
                                <span class="tooltip" data-area="message"></span>
                            </div>
                            <br> <label for="accountNo">Nomor Rekening Bank<span>*</span></label>
                            <div class="form_group_category textfield-wrap">
                                <input type="number" name="AccountNo" id="AccountNo"
                                    onKeyPress="if(this.value.length==this.maxLength) return false;"
                                    onkeydown="return digits(event)" maxlength="17" required="required"
                                    autocomplete="off" autofocus="autofocus">
                                <span class="tooltip" data-area="message"></span>
                            </div>
                            <br> <label for="">Nama Rekening<span>*</span></label>
                            <div class="form_group_category textfield-wrap">
                                <input type="text" name="AccountName" id="AccountName" value=''
                                    required="required" autocomplete="off"> <span class="tooltip"
                                    data-area="message"></span>
                            </div>
                            <br>
                        </div>

                        <input type="hidden" id="Accminlgth" name="Accminlgth" value='9'>
                        <input type="hidden" id="Accmaxlgth" name="Accmaxlgth" value='20'>
                        <ul class="btn_type">
                            <li><input class="btn_default" type="reset" value='Ulangi'></li>
                            <li><input type="submit" id="BankSubmit" value='Kirim'></li>
                        </ul>
                    </form>
                </div>

                <script src="https://cdn.robotaset.com/assets/js/pages/Bank.js"></script>
                <script src="https://cdn.robotaset.com/assets/js/pages/bankaccount.js"></script>
            </div>
        </div>
    <?php else: ?>
        <div class="row con_box">
            <div class="account_main info-page-content">
                <div id="Alert" class="alert  " role="alert" style="display: none;">
                </div>
                <div class="con_item" style="display: block;">
                    <h4>Akun Bank</h4>
                    <div class="form-group">
                        <label for="BankName">Nama Bank</label>
                        <span class="info_type" id="txtbankname"><?php echo e(strtoupper(auth()->user()->nama_bank)); ?></span>
                        <br> <label for="accountNo">Nomor Rekening Bank</label>
                        <span class="info_type" id="txtaccountno"><?php echo e(censor(auth()->user()->nomor_rekening, 2)); ?></span>
                        <br> <label for="">Nama Rekening</label>
                        <span class="info_type" id="txtaccountname"><?php echo e(censor(auth()->user()->nama_lengkap, 4)); ?></span>
                        <br>
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend.layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/infiny.idr.onl/public_html/core/resources/views/frontend/transaction/bank.blade.php ENDPATH**/ ?>