<?php $__env->startSection('panel'); ?>
    <div class="row">
        <div class="col-lg-4">
            <?php if(Route::is('admin.bank.edit')): ?>
                <div class="card">
                    <div class="card-body">
                        <h4 class="card-title">Banks Edit</h4>
                        <form class="form p-t-20" method="POST" action="<?php echo e(route('admin.bank.update',$bank->id)); ?>" enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>
                            <div class="form-group">
                                <label>Logo Bank / Qris</label>
                                <img class="input-group mb-3" style="width: 80px" src="<?php echo e(env('AWS_URL')); ?><?php echo e($bank->icon); ?>">
                                <div class="input-group mb-3">
                                    <input type="file" class="form-control" name="file">
                                </div>
                            </div>
                            <div class="form-group">
                                <label>Bank Name</label>
                                <div class="input-group mb-3">
                                    <select name="nama_bank" class="form-select" required>
                                        <option>-- Pilih Bank --</option>
                                        <option value="bca" <?php echo e($bank->nama_bank == 'bca' ? 'selected' : ''); ?>>BCA</option>
                                        <option value="bni" <?php echo e($bank->nama_bank == 'bni' ? 'selected' : ''); ?>>BNI</option>
                                        <option value="bri" <?php echo e($bank->nama_bank == 'bri' ? 'selected' : ''); ?>>BRI</option>
                                        <option value="mandiri" <?php echo e($bank->nama_bank == 'mandiri' ? 'selected' : ''); ?>>Mandiri</option>
                                        <option value="cimb" <?php echo e($bank->nama_bank == 'cimb' ? 'selected' : ''); ?>>CIMB Niaga</option>
                                        <option value="danamon" <?php echo e($bank->nama_bank == 'danamon' ? 'selected' : ''); ?>>Danamon</option>
                                        <option value="permata" <?php echo e($bank->nama_bank == 'permata' ? 'selected' : ''); ?>>Permata</option>
                                        <option value="ovo" <?php echo e($bank->nama_bank == 'ovo' ? 'selected' : ''); ?>>OVO</option>
                                        <option value="qris" <?php echo e($bank->nama_bank == 'qris' ? 'selected' : ''); ?>>QRIS</option>
                                        <option value="gopay" <?php echo e($bank->nama_bank == 'gopay' ? 'selected' : ''); ?>>Gopay</option>
                                        <option value="dana" <?php echo e($bank->nama_bank == 'dana' ? 'selected' : ''); ?>>Dana</option>
                                        <option value="panin" <?php echo e($bank->nama_bank == 'panin' ? 'selected' : ''); ?>>Panin</option>
                                        <option value="linkaja" <?php echo e($bank->nama_bank == 'linkaja' ? 'selected' : ''); ?>>LinkAja</option>
                                        <option value="sakuku" <?php echo e($bank->nama_bank == 'sakuku' ? 'selected' : ''); ?>>Sakuku</option>
                                        <option value="bsi" <?php echo e($bank->nama_bank == 'bsi' ? 'selected' : ''); ?>>BSI</option>
                                        <option value="jenius" <?php echo e($bank->nama_bank == 'jenius' ? 'selected' : ''); ?>>Jenius</option>
                                        <option value="neo" <?php echo e($bank->nama_bank == 'neo' ? 'selected' : ''); ?>>Neobank</option>
                                        <option value="jago" <?php echo e($bank->nama_bank == 'jago' ? 'selected' : ''); ?>>Jago</option>
                                        <option value="sinarmas" <?php echo e($bank->nama_bank == 'sinarmas' ? 'selected' : ''); ?>>Sinarmas</option>
                                        <option value="allo" <?php echo e($bank->nama_bank == 'allo' ? 'selected' : ''); ?>>Allobank</option>
                                        <option value="blu" <?php echo e($bank->nama_bank == 'blu' ? 'selected' : ''); ?>>Blu by BCA Digital</option>
                                        <option value="seabank" <?php echo e($bank->nama_bank == 'seabank' ? 'selected' : ''); ?>>Seabank</option>
                                        <option value="ocbc" <?php echo e($bank->nama_bank == 'ocbc' ? 'selected' : ''); ?>>OCBC</option>
                                    </select>
                                </div>
                            </div>
                            <div class="form-group">
                                <label>Account No</label>
                                <div class="input-group mb-3">
                                    <input type="text" name="nomor_rekening" class="form-control"
                                        placeholder="Account No / Qris Url" required="" aria-label="Username"
                                        value="<?php echo e($bank->nomor_rekening); ?>" aria-describedby="basic-addon11">
                                </div>
                            </div>
                            <div class="form-group">
                                <label>Account Name</label>
                                <div class="input-group mb-3">
                                    <input type="text" name="nama_pemilik" class="form-control"
                                        placeholder="Account Name" required="" aria-label="Username"
                                        value="<?php echo e($bank->nama_pemilik); ?>" aria-describedby="basic-addon11">
                                </div>
                            </div>
                            <button type="submit" class="btn btn-primary m-r-10">Submit</button>
                            <a href="<?php echo e(route('admin.bank.list')); ?>" class="btn btn-dark">Cancel</a>
                        </form>
                    </div>
                </div>
            <?php else: ?>
                <div class="card">
                    <div class="card-body">
                        <h4 class="card-title">Banks Create</h4>
                        <form class="form p-t-20" method="POST" action="<?php echo e(route('admin.bank.create')); ?>" enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>
                            <div class="form-group">
                                <label>Icon Bank ( Qris masukan disini )</label>
                                <div class="input-group mb-3">
                                    <input type="file" class="form-control" required="" name="file">
                                </div>
                            </div>
                            <div class="form-group">
                                <label>Bank Name</label>
                                <div class="input-group mb-3">
                                    <select name="nama_bank" class="form-select" required>
                                        <option>-- Pilih Bank --</option>
                                        <option value="bca">BCA</option>
                                        <option value="bni">BNI</option>
                                        <option value="bri">BRI</option>
                                        <option value="mandiri">Mandiri</option>
                                        <option value="cimb">CIMB Niaga</option>
                                        <option value="danamon">Danamon</option>
                                        <option value="permata">Permata</option>
                                        <option value="ovo">OVO</option>
                                        <option value="qris">QRIS</option>
                                        <option value="gopay">Gopay</option>
                                        <option value="dana">Dana</option>
                                        <option value="panin">Panin</option>
                                        <option value="linkaja">LinkAja</option>
                                        <option value="sakuku">Sakuku</option>
                                        <option value="bsi">BSI</option>
                                        <option value="jenius">Jenius</option>
                                        <option value="neo">Neobank</option>
                                        <option value="jago">Jago</option>
                                        <option value="sinarmas">Sinarmas</option>
                                        <option value="allo">Allobank</option>
                                        <option value="blu">Blu by BCA Digital</option>
                                        <option value="seabank">Seabank</option>
                                        <option value="ocbc">OCBC</option>
                                    </select>
                                </div>
                            </div>
                            <div class="form-group">
                                <label>Account No</label>
                                <div class="input-group mb-3">
                                    <input type="text" name="nomor_rekening" class="form-control"
                                        placeholder="Account No / Qris Url" required="" aria-label="Username"
                                        aria-describedby="basic-addon11">
                                </div>
                            </div>
                            <div class="form-group">
                                <label>Account Name</label>
                                <div class="input-group mb-3">
                                    <input type="text" name="nama_pemilik" class="form-control"
                                        placeholder="Account Name" required="" aria-label="Username"
                                        aria-describedby="basic-addon11">
                                </div>
                            </div>
                            <button type="submit" class="btn btn-primary m-r-10">Submit</button>
                        </form>
                    </div>
                </div>
            <?php endif; ?>
        </div>
        <div class="col-lg-8">
            <div class="card">
                <div class="card-body">
                    <h4 class="card-title">Banks Account</h4>
                </div>
                <div class="card-datatable table-responsive">
                    <table id="default-datatable" class="table table-bordered table-sm">
                        <thead>
                            <tr>
                                <th class="text-center" style="vertical-align: middle; font-size: 12px;">#</th>
                                <th class="text-center" style="vertical-align: middle; font-size: 12px;">Logo / Qris</th>
                                <th class="text-center" style="vertical-align: middle; font-size: 12px;">Bank Name</th>
                                <th class="text-center" style="vertical-align: middle; font-size: 12px;">Account No</th>
                                <th class="text-center" style="vertical-align: middle; font-size: 12px;">Account Name</th>
                                <th class="text-center" style="vertical-align: middle; font-size: 12px;">Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $banks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <th class="text-center" style="vertical-align: middle; font-size: 13px;"><?php echo e($loop->iteration); ?></th>
                                    <th class="text-center" style="vertical-align: middle; font-size: 12px;"><img style="width: 30px" src="<?php echo e(env('AWS_URL')); ?><?php echo e($item->icon); ?>"></th>
                                    <td class="text-center"
                                        style="vertical-align: middle; white-space: normal; font-size: 13px;"><?php echo e($item->nama_bank); ?>

                                    </td>
                                    <td class="text-center"
                                        style="vertical-align: middle; white-space: normal; font-size: 13px;"><?php echo e($item->nomor_rekening); ?>

                                    </td>
                                    <td class="text-center"
                                        style="vertical-align: middle; white-space: normal; font-size: 13px;"><?php echo e($item->nama_pemilik); ?>

                                    </td>
                                    <td class="text-center" style="vertical-align: middle; font-size: 13px;">
                                        <a href="<?php echo e(route('admin.bank.edit',$item->id)); ?>" class="btn btn-xs btn-primary"><span
                                                class="mdi mdi-pencil"></span></a>
                                        <a href="<?php echo e(route('admin.bank.delete',$item->id)); ?>" class="btn btn-xs btn-danger"
                                            onclick="return confirm('Are you sure want to delete this Banks?');"><span
                                                class="mdi mdi-trash-can"></span></a>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/zxtmtoay/taxi338.link-ofc.xyz/core/resources/views/backend/bank/bank.blade.php ENDPATH**/ ?>