<?php $__env->startSection('panel'); ?>
<div class="row">
    <div class="col-sm-5 mb-3">
        <div class="card">
            <div class="card-body">
                <?php if(Route::is('website.promotion.edit')): ?>
                <form role="form" action="<?php echo e(route('admin.website.promotion.update',$edb->id)); ?>" method="post"
                    enctype="multipart/form-data">
                    <input type="hidden" name="type" value="1">
                    <?php echo csrf_field(); ?>
                    <div class="form-group mb-2">
                        <label class="form-label">Image : (Optional)</label>
                        <a href="<?php echo e($edb->gambar); ?>" target="_blank"><img class="input-group mb-3" style="width: 150px;" src="<?php echo e(env('AWS_URL')); ?><?php echo e($edb->gambar); ?>"></a>
                        <input class="form-control" type="file" name="file">
                    </div>
                    <div class="form-group mb-2">
                        <label class="form-label">Promotion Title :</label>
                        <input class="form-control" type="text" name="judul" value="<?php echo e($edb->judul); ?>" required>
                    </div>
                    <div class="form-group mb-2">
                        <label class="form-label">Description :</label>
                        <textarea class="form-control summernoteEditor" type="text" name="deskripsi"><?php echo $edb->text; ?></textarea>
                    </div>
                    <div class="form-group mb-2">
                        <label class="form-label">Status :</label>
                        <select name="status" class="form-control" required>
                            <option> Pilih </option>
                            <option value="active" <?php echo e($edb->status == 'active'  ? 'selected' : ''); ?>>Active</option>
                            <option value="not" <?php echo e($edb->status == 'not'  ? 'selected' : ''); ?>>Not Actived</option>
                        </select>
                    </div>
                    <button type="submit" class="btn btn-primary mt-3">Publish</button>
                    <a href="<?php echo e(route('admin.website.promotion')); ?>" class="btn btn-dark mt-3">Cancel</a>
                </form>
                <?php else: ?>
                <form role="form" action="<?php echo e(route('admin.website.promotion.create')); ?>" method="post"
                    enctype="multipart/form-data">
                    <input type="hidden" name="type" value="1">
                    <?php echo csrf_field(); ?>
                    <div class="form-group mb-2">
                        <label class="form-label">Upload Image :</label>
                        <input class="form-control" type="file" name="file">
                    </div>
                    <div class="form-group mb-2">
                        <label class="form-label">Promotion Title :</label>
                        <input class="form-control" type="text" name="judul" required>
                    </div>
                    <div class="form-group mb-2">
                        <label class="form-label">Description :</label>
                        <textarea class="form-control summernoteEditor" type="text" name="deskripsi"></textarea>
                    </div>
                    <div class="form-group mb-2">
                        <label class="form-label">Status :</label>
                        <select name="status" class="form-control" required>
                            <option> Pilih </option>
                            <option value="active">Active</option>
                            <option value="not">Not Actived</option>
                        </select>
                    </div>
                    <button type="submit" class="btn btn-primary mt-3">Publish</button>
                </form>
                <?php endif; ?>
            </div>
        </div>
    </div>
    <div class="col-sm-7 mb-3">
        <!-- Invoice List Table -->
        <div class="card">
            <div class="card-datatable table-responsive">
                <table id="default-datatable" class="table table-bordered table-sm">
                    <thead>
                        <tr>
                            <th class="text-center" style="vertical-align: middle; font-size: 12px;">#</th>
                            <th class="text-center" style="vertical-align: middle; font-size: 12px;">Judul</th>
                            <th class="text-center" style="vertical-align: middle; font-size: 12px;">Image</th>
                            <th class="text-center" style="vertical-align: middle; font-size: 12px;">Status</th>
                            <th class="text-center" style="vertical-align: middle; font-size: 12px;">Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $promotion; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td class="text-center" style="vertical-align: middle; font-size: 14px;">
                                <?php echo e($loop->iteration); ?>

                            </td>
                            <td class="text-left" style="vertical-align: middle; white-space: normal; font-size: 14px;">
                                <?php echo e($item->judul); ?>

                            </td>
                            <th class="text-center" style="vertical-align: middle; font-size: 14px;"><img
                                    style="width: 120px;" src="<?php echo e(env('AWS_URL')); ?><?php echo e($item->gambar); ?>" loading="lazy"></th>
                            <td class="text-center"
                                style="vertical-align: middle; white-space: normal; font-size: 14px;">
                                <?php echo e($item->status); ?>

                            </td>
                            <td class="text-center" style="vertical-align: middle; font-size: 14px;">
                                <a href="<?php echo e(route('admin.website.promotion.edit',$item->id)); ?>" class="btn btn-xs btn-primary"><span
                                        class="mdi mdi-pencil"></span></a>
                                <a href="<?php echo e(route('admin.website.promotion.delete',$item->id)); ?>"
                                    class="btn btn-xs btn-danger"
                                    onclick="return confirm('Are you sure want to delete this Banks?');"><span
                                        class="mdi mdi-trash-can"></span></a>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/zxtmtoay/taxi338.link-ofc.xyz/core/resources/views/backend/promotion/promotion.blade.php ENDPATH**/ ?>