

<?php $__env->startSection('panel'); ?>
<h4 class="fw-bold py-3 mb-3">Update Result Pasaran</h4>

<div class="card">
    <div class="card-body">

        
        <div class="mb-3">
            <strong>Jumlah Taruhan yang sudah pasang:</strong> <?php echo e($taruhan_count); ?>

            <?php if($taruhan_count == 0): ?>
                <span class="text-danger">(Belum ada taruhan Rubah dari EDIT)</span>
            <?php endif; ?>
        </div>

        
        <form action="<?php echo e(route('admin.lottery.manage.result.update', $pasaran->id)); ?>" method="POST">
            <?php echo csrf_field(); ?>
            <div class="mb-3">
                <label class="form-label">Keluaran</label>
                <input type="text" name="keluaran" class="form-control" value="<?php echo e($pasaran->keluaran); ?>">
            </div>
            <div class="mb-3">
                <label class="form-label">Tanggal</label>
                <input type="text" name="tanggal" class="form-control" value="<?php echo e($pasaran->tanggal); ?>">
            </div>
            <div class="mb-3">
                <label class="form-label">Periode</label>
                <input type="number" name="periode" class="form-control" value="<?php echo e($pasaran->periode); ?>">
            </div>

            <button type="submit" class="btn btn-success" 
                <?php if($taruhan_count == 0): ?> disabled <?php endif; ?>>Update Result</button>
            <?php if($taruhan_count == 0): ?>
                <small class="text-muted">Tidak bisa update result karena belum ada taruhan.</small>
            <?php endif; ?>
        </form>

        
        <?php if($taruhan_count > 0): ?>
        <hr>
        <h5 class="mt-4">Detail Taruhan</h5>
        <div class="table-responsive">
            <table class="table table-bordered table-sm" id="taruhan-table">
                <thead class="table-dark">
                    <tr>
                        <th>#</th>
                        <th>Username</th>
                        <th>Market</th>
                        <th>Pasang</th>
                        <th>Amount</th>
                        <th>Amount Bet</th>
                        <th>Date</th>
                        <th>Win</th>
                        <th>Type</th>
                        <th>Status</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $taruhans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $t): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($loop->iteration); ?></td>
                        <td><?php echo e($t->username); ?></td>
                        <td><?php echo e($t->market); ?></td>
                        <td><?php echo e($t->pasang); ?></td>
                        <td><?php echo e($t->amount); ?></td>
                        <td><?php echo e($t->amount_bet); ?></td>
                        <td><?php echo e($t->date); ?></td>
                        <td><?php echo e($t->win); ?></td>
                        <td><?php echo e($t->type); ?></td>
                        <td>
                            <?php if($t->status == '0'): ?>
                                <span class="badge bg-danger">Kalah</span>
                            <?php elseif($t->status == '1'): ?>
                                <span class="badge bg-primary">Menunggu</span>
                            <?php elseif($t->status == '2'): ?>
                                <span class="badge bg-success">Sukses</span>
                            <?php else: ?>
                                <span class="badge bg-secondary"><?php echo e($t->status); ?></span>
                            <?php endif; ?>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
        <?php endif; ?>

    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
<script>
$(function(){
    $('#taruhan-table').DataTable({
        lengthMenu:[[25,50,100,-1],[25,50,100,"All"]],
        order:[[6,'desc']],
        columnDefs:[{className:'text-center',targets:'_all'}]
    });
});
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('backend.layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/infiny.idr.onl/public_html/core/resources/views/backend/lottery/update_result.blade.php ENDPATH**/ ?>